/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.utils.glazed;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import net.minecraft.class_243;
import org.joml.Vector3d;

public final class Utils {
    public static Color getMainColor(int alpha, int offset) {
        return new Color(255, 255, 255, alpha);
    }

    public static File getCurrentJarPath() throws URISyntaxException {
        return new File(Utils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
    }

    public static void overwriteFile(String urlString, File targetFile) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(10000);
            try (InputStream inputStream = connection.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(targetFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.flush();
            }
            connection.disconnect();
        }
        catch (Exception e) {
            System.err.println("Error downloading file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void copyVector(Vector3d destination, class_243 source) {
        destination.x = source.field_1352;
        destination.y = source.field_1351;
        destination.z = source.field_1350;
    }

    public static void copyVector(Vector3d destination, Vector3d source) {
        destination.x = source.x;
        destination.y = source.y;
        destination.z = source.z;
    }

    public static Vector3d toVector3d(class_243 vec3d) {
        return new Vector3d(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public static class_243 toVec3d(Vector3d vector3d) {
        return new class_243(vector3d.x, vector3d.y, vector3d.z);
    }

    public static double lerp(double start, double end, double progress) {
        return start + (end - start) * progress;
    }

    public static Vector3d lerp(Vector3d start, Vector3d end, double progress) {
        return new Vector3d(Utils.lerp(start.x, end.x, progress), Utils.lerp(start.y, end.y, progress), Utils.lerp(start.z, end.z, progress));
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

