/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseScrollEvent;
import meteordevelopment.meteorclient.events.render.GetFovEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_3532;

public class Zoom
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Double> zoom;
    private final Setting<Double> scrollSensitivity;
    private final Setting<Boolean> smooth;
    private final Setting<Boolean> cinematic;
    private final Setting<Boolean> hideHud;
    private final Setting<Boolean> renderHands;
    private boolean enabled;
    private boolean preCinematic;
    private double preMouseSensitivity;
    private double value;
    private double lastFov;
    private double time;
    private boolean hudManualToggled;

    public Zoom() {
        super(Categories.Render, "zoom", "Zooms your view.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.zoom = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("zoom")).description("How much to zoom.")).defaultValue(6.0).min(1.0).build());
        this.scrollSensitivity = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scroll-sensitivity")).description("Allows you to change zoom value using scroll wheel. 0 to disable.")).defaultValue(1.0).min(0.0).build());
        this.smooth = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("smooth")).description("Smooth transition.")).defaultValue(true)).build());
        this.cinematic = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("cinematic")).description("Enables cinematic camera.")).defaultValue(false)).build());
        this.hideHud = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("hide-HUD")).description("Whether or not to hide the Minecraft HUD.")).defaultValue(false)).build());
        this.renderHands = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-hands")).description("Whether or not to render your hands.")).defaultValue(false)).visible(() -> this.hideHud.get() == false)).build());
        this.autoSubscribe = false;
    }

    @Override
    public void onActivate() {
        if (!this.enabled) {
            this.preCinematic = this.mc.field_1690.field_1914;
            this.preMouseSensitivity = (Double)this.mc.field_1690.method_42495().method_41753();
            this.value = this.zoom.get();
            this.lastFov = ((Integer)this.mc.field_1690.method_41808().method_41753()).intValue();
            this.time = 0.001;
            MeteorClient.EVENT_BUS.subscribe(this);
            this.enabled = true;
        }
        if (this.hideHud.get().booleanValue() && !this.mc.field_1690.field_1842) {
            this.hudManualToggled = false;
            this.mc.field_1690.field_1842 = true;
        }
    }

    @Override
    public void onDeactivate() {
        if (this.hideHud.get().booleanValue() && !this.hudManualToggled) {
            this.mc.field_1690.field_1842 = false;
        }
    }

    @EventHandler
    public void onKeyPressed(KeyEvent event) {
        if (event.key != 290) {
            return;
        }
        this.hudManualToggled = true;
    }

    public void onStop() {
        this.mc.field_1690.field_1914 = this.preCinematic;
        this.mc.field_1690.method_42495().method_41748((Object)this.preMouseSensitivity);
        this.mc.field_1769.method_3292();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        this.mc.field_1690.field_1914 = this.cinematic.get();
        if (!this.cinematic.get().booleanValue()) {
            this.mc.field_1690.method_42495().method_41748((Object)(this.preMouseSensitivity / Math.max(this.getScaling() * 0.5, 1.0)));
        }
        if (this.time == 0.0) {
            MeteorClient.EVENT_BUS.unsubscribe(this);
            this.enabled = false;
            this.onStop();
        }
    }

    @EventHandler
    private void onMouseScroll(MouseScrollEvent event) {
        if (this.scrollSensitivity.get() > 0.0 && this.isActive()) {
            this.value += event.value * 0.25 * (this.scrollSensitivity.get() * this.value);
            if (this.value < 1.0) {
                this.value = 1.0;
            }
            event.cancel();
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (!this.smooth.get().booleanValue()) {
            this.time = this.isActive() ? 1.0 : 0.0;
            return;
        }
        this.time = this.isActive() ? (this.time += event.frameTime * 5.0) : (this.time -= event.frameTime * 5.0);
        this.time = class_3532.method_15350((double)this.time, (double)0.0, (double)1.0);
    }

    @EventHandler
    private void onGetFov(GetFovEvent event) {
        event.fov /= (float)this.getScaling();
        if (this.lastFov != (double)event.fov) {
            this.mc.field_1769.method_3292();
        }
        this.lastFov = event.fov;
    }

    public double getScaling() {
        double delta = this.time < 0.5 ? 4.0 * this.time * this.time * this.time : 1.0 - Math.pow(-2.0 * this.time + 2.0, 3.0) / 2.0;
        return class_3532.method_16436((double)delta, (double)1.0, (double)this.value);
    }

    public boolean renderHands() {
        return !this.isActive() || this.renderHands.get() != false;
    }
}

