/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class NbtUtils {
    public static <T extends ISerializable<?>> class_2499 listToTag(Iterable<T> list) {
        class_2499 tag = new class_2499();
        for (ISerializable item : list) {
            tag.add((Object)item.toTag());
        }
        return tag;
    }

    public static <T> List<T> listFromTag(class_2499 tag, ToValue<T> toItem) {
        ArrayList<T> list = new ArrayList<T>(tag.size());
        for (class_2520 itemTag : tag) {
            T value = toItem.toValue(itemTag);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <K, V extends ISerializable<?>> class_2487 mapToTag(Map<K, V> map) {
        class_2487 tag = new class_2487();
        for (K key : map.keySet()) {
            tag.method_10566(key.toString(), (class_2520)((ISerializable)map.get(key)).toTag());
        }
        return tag;
    }

    public static <K, V> Map<K, V> mapFromTag(class_2487 tag, ToKey<K> toKey, ToValue<V> toValue) {
        HashMap<K, V> map = new HashMap<K, V>(tag.method_10546());
        for (String key : tag.method_10541()) {
            map.put(toKey.toKey(key), toValue.toValue(tag.method_10580(key)));
        }
        return map;
    }

    public static boolean toClipboard(ISerializable<?> serializable) {
        return NbtUtils.toClipboard(serializable.toTag());
    }

    public static boolean toClipboard(class_2487 tag) {
        String preClipboard = MeteorClient.mc.field_1774.method_1460();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)tag, (OutputStream)byteArrayOutputStream);
            MeteorClient.mc.field_1774.method_1455(Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray()));
            return true;
        }
        catch (Exception e) {
            MeteorClient.LOG.error("Error copying NBT to clipboard!", (Throwable)e);
            MeteorClient.mc.field_1774.method_1455(preClipboard);
            return false;
        }
    }

    public static boolean fromClipboard(ISerializable<?> serializable) {
        class_2487 tag = NbtUtils.fromClipboard();
        if (tag == null) {
            return false;
        }
        class_2487 sourceTag = serializable.toTag();
        for (String key : sourceTag.method_10541()) {
            if (tag.method_10545(key)) continue;
            return false;
        }
        serializable.fromTag(tag);
        return true;
    }

    public static class_2487 fromClipboard() {
        try {
            byte[] data = Base64.getDecoder().decode(MeteorClient.mc.field_1774.method_1460().trim());
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            return class_2507.method_10629((InputStream)new DataInputStream(bis), (class_2505)class_2505.method_53898());
        }
        catch (Exception e) {
            MeteorClient.LOG.error("Invalid NBT data pasted!", (Throwable)e);
            return null;
        }
    }

    public static interface ToValue<T> {
        public T toValue(class_2520 var1);
    }

    public static interface ToKey<T> {
        public T toKey(String var1);
    }
}

